IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_CPL_VD]') AND type in (N'U'))
begin
CREATE TABLE [dbo].[EST_PROD_CPL_VD](
	[CD_CTR] [int] IDENTITY(1,1) NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[ANO] [int] NOT NULL,
	[MES] [int] NOT NULL,
	[TIPO_VENDA] [int] NOT NULL,
	[QT_VD] [money] NOT NULL,
	[VLR_VD] [money] NOT NULL,
 CONSTRAINT [PK_EST_PROD_CPL_VD] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_EST_PROD_CPL_VD] UNIQUE NONCLUSTERED 
(
	[CD_PROD] ASC,
	[CD_FILIAL] ASC,
	[MES] ASC,
	[ANO] ASC,
	[TIPO_VENDA] ASC,
	[CD_EMP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PROD_CPL_VD] ADD  CONSTRAINT [DF_EST_PROD_CPL_VD_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PROD_CPL_VD] ADD  CONSTRAINT [DF_EST_PROD_CPL_VD_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_PROD_CPL_VD] ADD  CONSTRAINT [DF_EST_PROD_CPL_VD_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_PROD_CPL_VD] ADD  CONSTRAINT [DF_EST_PROD_CPL_VD_ANO]  DEFAULT ((0)) FOR [ANO]

ALTER TABLE [dbo].[EST_PROD_CPL_VD] ADD  CONSTRAINT [DF_EST_PROD_CPL_VD_MES]  DEFAULT ((0)) FOR [MES]

ALTER TABLE [dbo].[EST_PROD_CPL_VD] ADD  CONSTRAINT [DF_EST_PROD_CPL_VD_TIPO_VENDA]  DEFAULT ((0)) FOR [TIPO_VENDA]

ALTER TABLE [dbo].[EST_PROD_CPL_VD] ADD  CONSTRAINT [DF_EST_PROD_CPL_VD_QT_VD]  DEFAULT ((0)) FOR [QT_VD]

ALTER TABLE [dbo].[EST_PROD_CPL_VD] ADD  CONSTRAINT [DF_EST_PROD_CPL_VD_VLR_VD]  DEFAULT ((0)) FOR [VLR_VD]

ALTER TABLE [dbo].[EST_PROD_CPL_VD]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_CPL_VD_EST_PROD_CPL] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_PROD])
REFERENCES [dbo].[EST_PROD_CPL] ([CD_EMP], [CD_FILIAL], [CD_PROD])

ALTER TABLE [dbo].[EST_PROD_CPL_VD] CHECK CONSTRAINT [FK_EST_PROD_CPL_VD_EST_PROD_CPL]
end

